﻿<!------------------------------------------
 #프로그램명	: 성적서 조회 (K-System)
 #날     짜	: 2019-02-25
 #업  체  명	: 덕산약품
 #담  당  자	: 김휘수(hwisu@duksan.kr)
 #홈페이지주소	: https://www.duksan.kr
 #화면의 용도	: SP를 사용하여 K-system에서 성적서를 조회하여 화면에 출력, PDF 다운로드
 #수 정 사 항	: (2019-02-28::최재원) 성적서 출력결과값의 행 사이 간격을 수정(CSS:#ca_print .ca_table2 tr td) = padding-top/bottom 1px -> 0px
 			  (2019-02-28::최재원) 해당 LotNo에 대한 재시험여부를 체크하여, 하단 Retest.Date, Mfg.Date 여부를 표시
------------------------------------------->

<?php
/** 성적서 **/
/** (Stored Procedure) duksan_Homepage_Report 사용 **/

    include $_SERVER['DOCUMENT_ROOT'].'/lib/lib.php';
    $code = $_GET["lot_num"];
    $msds_list = new Msds\Msds_Class();
    
    $result	= array();
    $result	= $msds_list -> lotNumber($conn, $code , "1");
    $result = sqlsrv_fetch_array($result);
    $result2 = $msds_list->lotNumber($conn, $code , "0");
	
	/* 재시험 여부 체크 (SourceType = 13 : 재시험) */
	$sql = "EXEC DUKSAN.dbo.DUKSAN_EXAMINATION_HOMEPAGE '{$code}'";
	$result3 = sqlsrv_fetch_array(sqlsrv_query($conn, $sql));
	$SourceType = $result3["SourceType"];


	/* 성적서 제품명 앞에 붙을 제조사명 조회 // 2019-02-21 심동선계장 요청으로 제조사명 표기 제거
	$sql = "SELECT A.[ItemSeq] ,A.[ItemNo], 
			(SELECT  MinorName FROM DUKSAN.dbo._TDAUMinor AS D33 WHERE (B.MngValSeq = MinorSeq)) AS MAKER
			FROM [DUKSAN].[dbo].[_TDAItem] AS A
			LEFT JOIN
			DUKSAN.dbo._TDAItemUserDefine AS B 
			ON  A.ItemSeq = B.ItemSeq AND B.MngSerl = '1000003'
			WHERE ItemNo like '{$result[ITEMGROUP]}'";

	$m_row = sqlsrv_fetch_array(sqlsrv_query($conn, $sql));
	$maker = $m_row["MAKER"] == "DSP" ? "Duksan" : $m_row["MAKER"];
	*/

?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"> <!--크로스 브라우징-->
<meta name ="google" content="notranslate"> <!-- 240708 브라우저(구글, 엣지) 자동번역 해제 -->
<title>성적서</title>
<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js"></script>
<!-- PDF 변환 -->
<script src="/js/html2canvas.js"></script>
<script src="/js/html2canvas.min.js"></script>
<script src="/js/bluebird.min.js"></script>
<script src="/js/jspdf.min.js"></script>
<!-- PDF 변환 -->
</head>

<?php     
    if($result[LotCheck] == "-9") {
        echo "<script>alert('존재하지 않는 Lot Number 입니다.'); window.self.close();</script>";
        exit;
    }
?>

<script language="JavaScript">
    function sWin() {

		window.resizeTo(800, 1080);
		
		setTimeout(function(){
			
			if(confirm('출력하시겠습니까?\n(PDF 다운로드는 공지사항을 참조하세요.)') == true) {
				window.print();
			}

			// down_chk();

		},1000);
    }

	function down_chk () {
		var confirm_chk = confirm('PDF 파일로 내려받기 하시겠습니까?\n(인터넷 환경에 따라 다운로드 시작 시간이 좀 걸릴 수 있습니다.)');
		
		if(confirm_chk == true) {
			pdf_load();
		}
	}

/// 원래없던기능 
function pdf_open() { // PDF 파일 다운로드 -> 문서형태
		var form = document.createElement('form');
		var code = '<?php echo $_GET[lot_num] ?>';

		form.setAttribute('method', 'POST');
		form.setAttribute('name', 'msds_frm');
		form.setAttribute('id', 'msds_frm');
		form.setAttribute('action', '/tcpdf/msds/print_e.php');
		form.setAttribute('target', 'msds');

		var msds_code = document.createElement('input');

		msds_code.setAttribute('type', 'hidden');
		msds_code.setAttribute('name', 'lot_num');
		msds_code.setAttribute('value', code);
		
		form.appendChild(msds_code);

		document.body.appendChild(form);

		form.submit();
	}



	function pdf_load() { // PDF 파일 다운로드
		var txt = $('.msdsName').html();
		var code = '<?php echo $_GET[lot_num] ?>';
		html2canvas(document.body, {
			  onrendered: function(canvas) {
			 
					// 캔버스를 이미지로 변환
					var imgData = canvas.toDataURL('image/png');
					 
					var imgWidth = 210; // 이미지 가로 길이(mm) A4 기준
					var pageHeight = imgWidth * 1.414;  // 출력 페이지 세로 길이 계산 A4 기준
					var imgHeight = canvas.height * imgWidth / canvas.width;
					var heightLeft = imgHeight;
				 
					var doc = new jsPDF('p', 'mm');
					var position = 0;
					 
					// 첫 페이지 출력
					doc.addImage(imgData, 'PNG', 0, position, imgWidth, imgHeight);
					heightLeft -= pageHeight;
					 
					// 한 페이지 이상일 경우 루프 돌면서 출력
					while (heightLeft >= 20) {
					  position = heightLeft - imgHeight;
					  doc.addPage();
					  doc.addImage(imgData, 'PNG', 0, position, imgWidth, imgHeight);
					  heightLeft -= pageHeight;
					}
			 
					// 파일 저장
					doc.save(txt+'('+code+').pdf');
			  }
		});
	}
</script>

<script> 
	$(function(){

	});
</script>
<style>
    #ca_print{
        width:100%;
    	margin: 0 auto;
    }
    #ca_print .ca_tit{
    	width: 97%;
    	margin: 10px auto;
	    margin-bottom: 20px;
    	text-align: center;
    }
    #ca_print .ca_table{
       width: 95%; 
       margin:5px auto;
       text-align: center;
    }
    
    #ca_print .ca_table tr th{
       font-size: 22px;
    }
    
    #ca_print .ca_table tr td{
        font-size: 14px;
    }
    
    #ca_print .ca_table2 {
       width: 95%; 
       margin:10px auto;
       text-align: center;
       margin-bottom:30px;
    }
    
    #ca_print .ca_table2 tr th{
       padding-bottom:3px;
       color: #ff0000;
       font-size:13px;
    }
    
    #ca_print .ca_table2 tr td{
       /*border-bottom:1px solid #c3c3c3;*/
		padding-top:0px;
		padding-bottom:0px;
		font-size:11px;

    }
    
    #ca_print .ca_table3 {
       width:40%; 
       margin-left:15px;
       font-size:12px;
    }
    
    #ca_print .ca_table3 tr th,
    #ca_print .ca_table3 tr td{
       text-align:left;
    }
    
    
    #ca_print .bottom_sign{
	    position: fixed;
	    top: 85%;
		width: 100%;
		margin: 10px auto;
		padding: 15px;
		padding-top: 20px;
    }
</style>

<body onload="sWin()" >

<div id="ca_print">
	<p class="ca_tit">
		<?php if(strstr($result["Spec"], "Birch")) { // 231218 김전임: 버찌인 경우 ?>
			<img src="../../images/sub/title_01_brich.gif" style="width:100%" alt="규격성적서">
		<?php } else { // 재시험이 아닌 경우 ?>
			<img src="../../images/sub/title_01.gif" style="width:100%" alt="규격성적서">			
		<?php } ?>
	</p>
	<div style="min-height:600px;">
	<table class="ca_table">
		<tr>
			<th colspan="4" class="msdsName"><?php echo trim($result["ItemName"])?></th>
		</tr>
		<tr>
			<td colspan="4" style="font-size:13px; padding-top:15px;">
				[<?php echo $result["CASNo"] ?>]&nbsp;&nbsp;(<?php echo $result["msds_Formula"] ?>)&nbsp;&nbsp;FW:<?php echo $result["msds_FormulaWeight"] ?>
			</td>
		</tr>
		<tr style="font-weight: bold;">
		<?php if($result["AssetSeq"] == "2" || $result["AssetSeq"] == "4") { ?>
			<td rowspan="2" colspan="2" style="text-align:left; vertical-align:middle">
				Product code. <?php echo trim($result["ITEMGROUP"]) ?>
			</td>
		<?php if($result["GRADE"] == "ogarnic") { //<!-- 221122김계장 : 오가닉일 때 빈값 
		} else { ?>
			<td colspan="2" style="text-align:right;">
				<?php echo trim($result["GRADE"])?>&nbsp;Grade
			</td>
		<?php } ?>		
		</tr>
		<?php } ?>
		<tr style="font-weight: bold;">
			<td colspan="2" style="text-align:right;">
				Lot-<?php echo $result["LotNo"] ?>
			</td>
		</tr>
	</table>
	<!-- <p style="border-bottom:1px solid #b5b2ac; width:84%; margin:0px auto; margin-bottom:10px;"></p> -->
	<table class="ca_table2" cellspacing="0">
		<tr>
			<th>TESTS</th>
			<th>UNIT</th>
			<th>SPECIFICATION</th>
			<th>RESULTS</th>
		</tr>
		<?php while($row = sqlsrv_fetch_array($result2)) { ?>
		<tr>
			<td style="text-align:left;"><?php echo str_replace(" ", "&nbsp;", $row["UMQCTitleName"]) ?></td>
			<td><?php echo $row["Remark"] != "" ? $row["Remark"] : "-" ?></td>
			<td><?php echo $row["TestingCond"] != "" ? $row["TestingCond"] : "-" ?></td>
			<td><?php echo $row["TestingCondition"] != "" ? $row["TestingCondition"] : "-" ?></td>
		</tr>
		<?php } ?>
	</table>
	<table class="ca_table3" >
		<tr>
			<th>
			<?php if($SourceType == "13") { // 재시험인 경우 ?>
				Retest. Date :
			<?php } else { // 재시험이 아닌 경우 ?>
				Mfg. Date :
			<?php } ?>
			</th>
			<td><?php echo date("Y-m-d", strtotime($result["WORKDATE"])) ?></td>
		</tr>
		<?php if($result["COMPARISON"] != "") { ?>
		<tr>
			<th>Exp. Date :</th>
			<td><?php echo $result["COMPARISON"] ?></td>
		</tr>
		<?php } ?>
		
		<?php if($result["GRADE"] == "ogarnic") { //<!-- 221122김계장 : 오가닉일 때 빈값 
		} else { ?>
			<?php if($result["TESTMETHOD"] != "") { ?>
			<tr>
				<th>Test Method :</th>
				<td><?php echo $result["TESTMETHOD"] ?></td>
			</tr>
			<?php } ?>
		<?php } ?>			
		<?php if($result["SampleCollectEmpName"] != "") { ?>
		<tr>
			<th>Tested by :</th>
			<td><?php echo $result["SampleCollectEmpName"] ?></td>
		</tr>
		<?php } ?>
	</table>
	</div>
	<table class="bottom_sign">
        <tr>
			<td style="width:65%;">
				<p style="font-size:12px; line-height:15px;">
				<b style="font-size:14px; line-height:20px;line-height:25px;">DUKSAN PURE CHEMICALS CO. LTD</b><br>
				    53, Sinwon-ro 133beon-gil, Danwon-gu, Ansan-si, Gyeonggi-do, Korea<br>
					TEL : +82-31-495-4057	FAX : +82-31-495-8364<br>
					World Wide Web : WWW.DUKSAN.KR<br>
					E-mail : QC@DUKSAN.KR</p>
			</td>
			<td style="text-align: center;">
<!-- 최종승인자 년도별 출력로직 20201230 김계장-->
<?php
if($result["WORKDATE"] <= 20180531) //
	{ ?>
	<img src="/images/sub/choi.gif" width="180" height="101"> 
<?php
} else if($result["WORKDATE"] >= 20180601 && $result["WORKDATE"] <= 20201231) 
	{
?>
<img src="/images/sub/kim.gif" width="180" height="101">
<?php } else {?>
<img src="/images/sub/parksungsam.jpg" width="180" height="101">
<?php } ?>
<!--기존 <p><img src="/images/sub/kim.gif" width="180" height="101"></p> -->
<!-- 최종승인자 년도별 출력로직 끝 20201230 김계장-->			
			</td>
		</tr>
	</table>

  </div>

</body>
</html>